package ru.yandex.chemodan.app.worker2.queued;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.mongo.MongoCollection;
import ru.yandex.commune.mongo.MongoDefaultInterceptors;
import ru.yandex.commune.mongo.MongoHolder;
import ru.yandex.commune.mongo.MongoUtils;

/**
 * @author tolmalev
 */
public class LongTasksDao {

    private final MongoCollection<String, LongTask> collection;

    public LongTasksDao(DB db) {
        collection = new MongoCollection<String, LongTask>(
                MongoUtils.getCollection(db, "long_tasks"),
                LongTask.class,
                MongoHolder.defaultBenderConfiguration(),
                MongoDefaultInterceptors.defaultInterceptors());
    }

    public ListF<LongTask> list() {
        return collection.find(new BasicDBObject());
    }

    public Option<LongTask> find(String id) {
        return collection.findById(id);
    }

    public void updateTask(LongTask newTaskState) {
        collection.updateReplace(new BasicDBObject("_id", newTaskState.id), newTaskState);
    }

    public void insert(LongTask task) {
        collection.insert(task);
    }

    public void remove(String longTaskId) {
        collection.removeByIdRange(longTaskId, longTaskId);
    }
}
