package ru.yandex.chemodan.app.worker2.staff;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.zk.registries.staff.YandexStaffUser;
import ru.yandex.chemodan.zk.registries.staff.YandexStaffUserRegistry;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.inside.passport.login.PassportLogin;
import ru.yandex.inside.staff.v3.StaffApi;
import ru.yandex.inside.staff.v3.model.Person;

/**
 * @author tolmalev
 */
public class UpdateYandexStaffUserRegistryTask extends CronTask {
    private final YandexStaffUserRegistry registry;
    private final StaffApi staffApi;
    private final Blackbox2 publicBlackbox;

    public UpdateYandexStaffUserRegistryTask(YandexStaffUserRegistry registry, StaffApi staffApi,
            Blackbox2 publicBlackbox)
    {
        this.registry = registry;
        this.staffApi = staffApi;
        this.publicBlackbox = publicBlackbox;
    }

    @Override
    public TaskQueueName queueName() {
        return TaskQueueName.CRON;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(1);
    }

    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(Duration.standardHours(1));
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        SetF<YandexStaffUser> allUsers =
                staffApi.persons().getAll(false).toList().filterMap(person -> person.getYandexAccount()
                        .filterMap(Person.YandexAccount::getLoginO)
                        .filterMap(login -> {
                            Option<PassportUid> uidO =
                                    publicBlackbox.oldHelper().uidByLogin(PassportLogin.cons(login));

                            if (!uidO.isPresent()) {
                                return Option.empty();
                            }
                            return Option.of(new YandexStaffUser(
                                    uidO.get(),
                                    login,
                                    new PassportUid(person.getUid()),
                                    person.getLogin()
                            ));
                        })).unique();

        ListF<PassportUid> allUsersUids = allUsers.map(YandexStaffUser::getInternalUid);

        SetF<YandexStaffUser> inRegistry = registry.getAll().unique();

        SetF<YandexStaffUser> toUpdate = allUsers.filter(user -> !inRegistry.containsTs(user));
        ListF<PassportUid> toRemove = inRegistry
                .map(YandexStaffUser::getInternalUid)
                .filter(user -> !allUsersUids.containsTs(user));

        toRemove.forEach(registry::remove);
        toUpdate.forEach(registry::put);
    }
}
