package ru.yandex.chemodan.app.worker2.staff;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.blackbox.ProdBlackboxContextConfiguration;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.zk.registries.staff.YandexStaffUserRegistry;
import ru.yandex.chemodan.zk.registries.staff.YandexStaffUserRegistryContextConfiguration;
import ru.yandex.commune.json.jackson.JodaTimeModule;
import ru.yandex.commune.json.jackson.StringEnumModule;
import ru.yandex.commune.json.jackson.bolts.BoltsModule;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.inside.staff.v3.StaffApi;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        YandexStaffUserRegistryContextConfiguration.class,
        ProdBlackboxContextConfiguration.class
})
public class YandexStaffRegistryUpdaterContextConfiguration {

    @Bean
    public UpdateYandexStaffUserRegistryTask updateYandexStaffUserRegistryTask(YandexStaffUserRegistry registry, StaffApi staffApi,
                                                                               @Qualifier("blackbox2") Blackbox2 blackbox)
    {
        return new UpdateYandexStaffUserRegistryTask(registry, staffApi, blackbox);
    }

    @Bean
    public StaffApi staffApi(
            @Value("${staff.oauth.token:-}")
            String token,
            @Value("${staff.endpoint:-}")
            String endpoint)
    {
        ObjectMapper mapper =
                new ObjectMapper().registerModules(new StringEnumModule(), new BoltsModule(), new JodaTimeModule());

        return StaffApi
                .builder()
                .oauth2(token)
                .httpClient(staffHttpConfigurator().configure())
                .endpoint(endpoint)
                .mapper(mapper)
                .build();
    }

    @Bean
    @OverridableValuePrefix("staff")
    public HttpClientConfigurator staffHttpConfigurator() {
        return new HttpClientConfigurator();
    }
}
