package ru.yandex.chemodan.app.worker2.stat;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 */
public class RecalcYqlStatOnetimeTask extends OnetimeTaskSupport<RecalcYqlStatOnetimeTask.Parameters> {
    public static final TaskQueueName TASK_QUEUE_NAME = new TaskQueueName("yql-stat");

    private final YqlStatTasksManager manager;

    public RecalcYqlStatOnetimeTask(YqlStatTasksManager manager) {
        super(Parameters.class);
        this.manager = manager;
    }

    public RecalcYqlStatOnetimeTask(String yqlStatId, Instant startDate, Instant endDate) {
        super(new Parameters(yqlStatId, startDate, endDate));
        this.manager = null;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        manager.executeYqlStatForSomeDays(parameters.yqlStatId, parameters.startDate, parameters.endDate);
    }

    @Override
    public TaskQueueName queueName() {
        return TASK_QUEUE_NAME;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(23);
    }

    @BenderBindAllFields
    static class Parameters {
        public final String yqlStatId;
        public final Instant startDate;
        public final Instant endDate;

        Parameters(String yqlStatId, Instant startDate, Instant endDate) {
            this.yqlStatId = yqlStatId;
            this.startDate = startDate;
            this.endDate = endDate;
        }
    }
}
