package ru.yandex.chemodan.app.worker2.stat;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.worker2.stat.admin.YqlStatAdminContextConfiguration;
import ru.yandex.commune.bazinga.BazingaWorkerApp;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;
import ru.yandex.inside.statface.StatfaceClient;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author tolmalev
 */
@Configuration
@Import({
    YqlStatAdminContextConfiguration.class
})
public class YqlStatContextConfiguration {

    @Bean
    public StatfaceClient statfaceClient(@Value("${statface.token}") String token) {
        return new StatfaceClient(token);
    }

    @Bean
    public YqlStatTasksManager yqlStatTasksManager(
            ZkManager zkManager,
            @Qualifier("zkRoot") ZkPath zkRoot,
            @Value("${yql.datasource.url}") String yqlDatasourceUrl,
            @Value("${report.yql.token}") String yqlToken,
            @Value("${report.yql.slow.token}") String recalcYqlToken,
            BazingaWorkerApp bazingaWorkerApp,
            StatfaceClient statfaceClient)
    {

        if ("".equals(StringUtils.trimToEmpty(recalcYqlToken))) {
            recalcYqlToken = yqlToken;
        }

        YqlStatTasksManager manager = new YqlStatTasksManager(
                zkRoot.child("dynamic_yql_stat"),
                bazingaWorkerApp,
                statfaceClient,
                yqlDatasourceUrl,
                yqlToken,
                recalcYqlToken);

        zkManager.addClient(manager);

        return manager;
    }

    @Bean
    public RecalcYqlStatOnetimeTask recalcYqlStatOnetimeTask(YqlStatTasksManager manager) {
        return new RecalcYqlStatOnetimeTask(manager);
    }
}
