package ru.yandex.chemodan.app.worker2.stat;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.inside.statface.ReportConfig;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@BenderBindAllFields
public class YqlStatTaskInfo extends DefaultObject {
    public final String id;
    public final String description;
    public final String reportName;

    public final String title;

    public final ListF<String> simpleDimensions;
    public final ListF<String> simpleMeasures;

    public final String yql;

    public YqlStatTaskInfo(String id, String description, String title, String reportName,
            ListF<String> simpleDimensions, ListF<String> simpleMeasures, String yql)
    {
        this.id = id;
        this.description = description;
        this.reportName = reportName;
        this.title = title;
        this.simpleDimensions = simpleDimensions;
        this.simpleMeasures = simpleMeasures;
        this.yql = yql;
    }

    public ReportConfig getReportConfig() {
        ReportConfig config = new ReportConfig();
        config.setTitle(title);

        simpleDimensions.forEach(d -> config.addDimension(d, ReportConfig.FieldType.STRING));
        simpleMeasures.forEach(m -> config.addMeasure(m, ReportConfig.FieldType.NUMBER));

        return config;
    }
}
