package ru.yandex.chemodan.app.worker2.stat;

import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class YqlStatTasksManagerTest {
    @Test
    public void prepareYql() throws Exception {
        Assert.equals(
                "SELECT * FROM RANGE(`statbox/mpfs-access-log`, `2017-01-12`, `2017-01-12`)",
                YqlStatTasksManager.prepareYql("SELECT * FROM {{//statbox/mpfs-access-log}}",
                        "2017-01-12", "2017-01-12")
        );

        Assert.equals(
                "SELECT * FROM RANGE(`statbox/mpfs-access-log`, `2017-01-12`, `2017-01-12`)",
                YqlStatTasksManager.prepareYql("SELECT * FROM {{statbox/mpfs-access-log}}",
                        "2017-01-12", "2017-01-12")
        );

        Assert.equals(
                "PRAGMA yt.DefaultOperationWeight=\"0.1\";\n" +
                "SELECT * FROM RANGE(`statbox/mpfs-access-log`, `2017-01-12`, `2017-01-15`)",
                YqlStatTasksManager.prepareYql("SELECT * FROM {{//statbox/mpfs-access-log}}",
                        "2017-01-12", "2017-01-15")
        );
    }

    @Test
    public void prepareYqlTwoTables() {
        Assert.equals(
                "PRAGMA yt.DefaultOperationWeight=\"0.1\";\n" +
                "SELECT * FROM RANGE(`statbox/mpfs-access-log`, `2017-01-12`, `2017-01-15`) "
                        + "JOIN RANGE(`statbox/mpfs-access-log-2`, `2017-01-12`, `2017-01-15`)",
                YqlStatTasksManager.prepareYql(
                        "SELECT * FROM {{//statbox/mpfs-access-log}} JOIN {{//statbox/mpfs-access-log-2}}",
                        "2017-01-12", "2017-01-15")
        );
    }

    @Test
    public void parseDate() {
        Assert.equals("2017-01-12",
                YqlStatTasksManager.formatDateForYql(YqlStatTasksManager.parseDateFromYql("2017-1-12")));

        Assert.equals("2017-01-02",
                YqlStatTasksManager.formatDateForYql(YqlStatTasksManager.parseDateFromYql("2017-1-2")));

        for (int month = 10; month <= 12; month++) {
            for (int day = 10; day <= 30; day++) {
                String dateStr = "2017-" + month + "-" + day;

                Assert.equals(dateStr,
                        YqlStatTasksManager.formatDateForYql(YqlStatTasksManager.parseDateFromYql(dateStr)));
            }
        }
    }
}
