package ru.yandex.chemodan.app.worker2.stat.admin;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.worker2.stat.YqlStatTasksManager;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.bazinga.BazingaTaskManager;

/**
 * @author tolmalev
 */
@Configuration
public class YqlStatAdminContextConfiguration {
    @Autowired
    private AdminApp adminApp;

    @Bean
    public YqlStatAdminPage yqlStatAdminPage(YqlStatTasksManager manager, BazingaTaskManager bazingaTaskManager) {
        YqlStatAdminPage page = new YqlStatAdminPage(manager, bazingaTaskManager);

        adminApp.registerAdminPage("Yql stat", Option.of("Bazinga Cron"), page);
        return page;
    }

}
