<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        exclude-result-prefixes="xsl xs z"
        xmlns:z="urn:zscript-functions"
        version="2.0">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/lib/bootstrap-select.min.js"/>
        <script type="text/javascript" src="/z/r/lib/bootstrap-typeahead.min.js"/>
        <script type="text/javascript" src="/z/r/lib/jquery.serialize-object.min.js"/>
        <script type="text/javascript" src="/z/r/common/modal-edit-form.js"/>
        <script type="text/javascript" src="/z/r/yql-stat/YqlStatAdminPage-edit.js"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <xsl:apply-templates select="tasks"/>
        <xsl:apply-templates select="." mode="modal-edit-form"/>
    </xsl:template>

    <xsl:template match="tasks">
        <div id="main-content">
            <div class="container">
                <h3>
                    Edit task
                    <a href="#" class="btn btn-default" onclick="return showRecalcForm();">Пересчитать</a>
                </h3>
                <form width="100%" method="POST" action="/z/yql-stat/save">
                    <table border="0" width="100%">
                        <tr>
                            <td width="20%">Id:</td>
                            <td>
                                <xsl:value-of select="id"/>
                                <input name="id" type="hidden" class="form-control" value="{id}"/>
                            </td>
                        </tr>
                        <tr>
                            <td>Заголовок для StatFace:</td>
                            <td>
                                <input name="title" type="text" class="form-control" value="{title}"/>
                            </td>
                        </tr>
                        <tr>
                            <td>Путь к отчету на StatFace:</td>
                            <td>
                                <input name="report-name" type="text" class="form-control" value="{report-name}"/>
                            </td>
                        </tr>
                        <tr>
                            <td>Описание:</td>
                            <td>
                                <input name="description" type="text" class="form-control" value="{description}"/>
                            </td>
                        </tr>
                        <tr>
                            <td>Размерности (dimension):</td>
                            <td>
                                <input name="dimensions" type="text" class="form-control" value="{string-join(simple-dimensions, ',')}"
                                        placeholder="Список не-числовых полей из YQL результата"/>
                            </td>
                        </tr>
                        <tr>
                            <td>Метрики (measures):</td>
                            <td>
                                <input name="measures" type="text" class="form-control" value="{string-join(simple-measures, ',')}"
                                       placeholder="Список числовых полей из YQL результата"/>
                            </td>
                        </tr>
                        <tr>
                            <td>Yql:</td>
                            <td>
                                <textarea name="yql" rows="20" class="form-control" value="{yql}">
                                    <xsl:value-of select="yql"/>
                                </textarea>
                            </td>
                        </tr>
                    </table>
                    <button type="submit" class="btn btn-success">Save</button>
                </form>
                <div class="info">
                </div>
            </div>
        </div>
    </xsl:template>

    <xsl:include href="classpath:ru/yandex/chemodan/admin/common/modal-edit-form.xsl"/>

    <xsl:template match="content" mode="modal-edit-form">
        <form class="edit-form" method="POST" action="/z/yql-stat/recalc">
            <input name="id" type="hidden" value="{tasks/id}"/>
            <xsl:call-template name="modal-edit-form">
                <xsl:with-param name="id" select="'recalc-form'"/>
                <xsl:with-param name="size" select="'s'"/>
                <xsl:with-param name="btn-text" select="'Пересчитать'"/>
                <xsl:with-param name="btn-type" select="'submit'"/>
                <xsl:with-param name="title" select="'Пересчитать отчет за прошедшие даты'"/>

                <xsl:with-param name="content">
                    <xsl:apply-templates select="." mode="edit-form"/>
                </xsl:with-param>
            </xsl:call-template>
        </form>
    </xsl:template>

    <xsl:template match="content" mode="edit-form">
        <dl class="dl-horizontal">
            <dt>От</dt>
            <dd>
                <div class="form-group">
                    <input id="recalc-from-date" name="from" type="date" class="form-control"/>
                </div>
            </dd>
            <dt>До</dt>
            <dd>
                <div class="form-group">
                    <input id="recalc-to-date" name="to" type="date" class="form-control"/>
                </div>
            </dd>
        </dl>
    </xsl:template>

</xsl:stylesheet>
