<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        exclude-result-prefixes="xsl xs z"
        xmlns:z="urn:zscript-functions"
        version="2.0">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/lib/bootstrap-select.min.js"/>
        <script type="text/javascript" src="/z/r/lib/bootstrap-typeahead.min.js"/>
        <script type="text/javascript" src="/z/r/lib/jquery.serialize-object.min.js"/>
        <script type="text/javascript" src="/z/r/common/modal-edit-form.js"/>
        <script type="text/javascript" src="/z/r/jobs-cleaner/cleaning-edit.js"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <h3>Yql stat cron <a href="https://bazinga.disk.yandex-team.ru/z/bazinga/onetime-jobs/recalcYqlStatOnetime?st=running">Running YQL</a></h3>
        <table class="table table-striped table-condensed table-bordered">
            <tr>
                <th width="1%">id</th>
                <th width="20%">Заголовок в статфейсе</th>
                <th>Описание</th>
                <th>Полезные ссылки</th>
            </tr>
            <xsl:for-each select="tasks">
                <tr>
                    <td>
                        <xsl:value-of select="id"/>
                    </td>
                    <td>
                        <xsl:value-of select="title"/>
                        (<a href="/z/yql-stat/edit?id={id}">edit</a>)
                        (<a href="https://stat.yandex-team.ru/{report-name}">statface</a>)
                    </td>
                    <td>
                        <xsl:value-of select="description"/>
                    </td>
                    <td>
                        <a href="/z/bazinga/tasks/statface_{id}">Bazinga</a>
                    </td>
                </tr>
            </xsl:for-each>
        </table>

        <form method="GET" action="/z/yql-stat/edit" class="edit-form" >
            <dl class="dl-horizontal">
                <dt>
                    <button type="submit" class="btn btn-success">Создать</button>
                </dt>
                <dd>
                    <div class="form-group">
                        <input name="id" type="text" class="form-control" placeholder="unique_task_id"/>
                    </div>
                </dd>
            </dl>
        </form>

    </xsl:template>

</xsl:stylesheet>
