package ru.yandex.chemodan.app.worker2.stat.admin;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.worker2.stat.RecalcYqlStatOnetimeTask;
import ru.yandex.chemodan.app.worker2.stat.YqlStatTaskInfo;
import ru.yandex.chemodan.app.worker2.stat.YqlStatTasksManager;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.EmptyContentPojo;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.XmlRootElement;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.random.Random2;

/**
 * @author tolmalev
 */
@ActionContainer
public class YqlStatAdminPage {

    private final YqlStatTasksManager manager;
    private final BazingaTaskManager bazingaTaskManager;

    public YqlStatAdminPage(YqlStatTasksManager manager, BazingaTaskManager bazingaTaskManager) {
        this.manager = manager;
        this.bazingaTaskManager = bazingaTaskManager;
    }

    @ZAction(defaultAction = true)
    @Path("/yql-stat")
    public ListYqlStatTasks index() {
        return new ListYqlStatTasks(manager.getAll().toList().sortedBy(i -> i.id));
    }

    @ZAction
    @Path("/yql-stat/edit")
    public ListYqlStatTasks edit(@RequestParam("id") String id) {
        return new ListYqlStatTasks(manager.getAll()
                .find(task -> task.id.equals(id))
                .firstO()
                .getOrElse(() -> defaultTask(id))
        );
    }

    private YqlStatTaskInfo defaultTask(String id) {
        while (manager.getO(id).isPresent()) {
            id = Random2.R.nextAlnum(10);
        }

        return new YqlStatTaskInfo(
                id,
                "Здесь нужно написать, что это за отчет. Будет отображаться в админке в списке отчетов.",
                "Звголовок отчета " + id,
                "Disk/Adhoc/report_" + id,
                Cf.list(),
                Cf.list(),
                "SELECT\n"
                        + "    COUNT(*) as cnt\n"
                        + "FROM\n"
                        + "    {{//statbox/ydisk-mpfs-access-log}}\n"
                        + "WHERE\n"
                        + "    appname=\"platform\"\n"
                        + ";"
        );
    }

    @Path(value = "/yql-stat/save", methods = HttpMethod.POST)
    public EmptyContentPojo save(
            @RequestParam("id") String id,
            @RequestParam("description") String description,
            @RequestParam("title") String title,
            @RequestParam("reportName") String reportName,
            @RequestParam("dimensions") Option<String> dimensions,
            @RequestParam("measures") Option<String> measures,
            @RequestParam("yql") String yql)
    {
        manager.put(new YqlStatTaskInfo(
                id, description, title, reportName,
                Cf.list(dimensions.getOrElse("").split(",")).map(StringUtils::trimToNull).filterNotNull(),
                Cf.list(measures.getOrElse("").split(",")).map(StringUtils::trimToNull).filterNotNull(),
                yql
        ));

        throw new ZRedirectException("/yql-stat/edit?id=" + UrlUtils.urlEncode(id));
    }

    @Path(value = "/yql-stat/recalc", methods = HttpMethod.GET)
    public ListYqlStatTasks recalcInfo(@RequestParam("id") String id) {
        return edit(id);
    }

    @Path(value = "/yql-stat/recalc", methods = HttpMethod.POST)
    public EmptyContentPojo recalc(
            @RequestParam("id") String id,
            @RequestParam("from") String from,
            @RequestParam("to") String to)
    {
        Validate.notEmpty(id);
        bazingaTaskManager.schedule(new RecalcYqlStatOnetimeTask(
                id,
                YqlStatTasksManager.parseDateFromYql(from),
                YqlStatTasksManager.parseDateFromYql(to)
        ));
        throw new ZRedirectException("/z/bazinga/onetime-jobs/recalcYqlStatOnetime");
    }

    @BenderBindAllFields
    @XmlRootElement(name = "content")
    private static class ListYqlStatTasks {
        public final ListF<YqlStatTaskInfo> tasks;

        public ListYqlStatTasks(ListF<YqlStatTaskInfo> tasks) {
            this.tasks = tasks;
        }

        public ListYqlStatTasks(YqlStatTaskInfo taskInfo) {
            this(Cf.list(taskInfo));
        }
    }
}
