package ru.yandex.chemodan.app.worker2.wakeup;

import org.joda.time.Duration;

import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleExponential;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ScheduleWakeUpPushRangeTask extends OnetimeTaskSupport<ScheduleWakeUpPushRangeTask.Params> {
    private final WakeUpPushManager manager;

    public ScheduleWakeUpPushRangeTask(YPath ytPath, long startIndex, long endIndex) {
        super(new Params(ytPath.toString(), startIndex, endIndex));
        this.manager = null;
    }

    public ScheduleWakeUpPushRangeTask(WakeUpPushManager manager) {
        super(Params.class);
        this.manager = manager;
    }

    @Override
    protected void execute(Params params, ExecutionContext context) {
        manager.scheduleWakeUpPushTasksOrSendBatch(params.toPathWithRange());
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(1);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleExponential(Duration.standardMinutes(2), 4);
    }

    @BenderBindAllFields
    static class Params extends DefaultObject {
        private final String path;
        private final long startIndex;
        private final long endIndex;

        private Params(String path, long startIndex, long endIndex) {
            this.path = path;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        private YPath toPathWithRange() {
            return YPath.simple(path)
                    .withRange(startIndex, endIndex);
        }
    }
}
