package ru.yandex.chemodan.app.worker2.wakeup;

import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleWithRetry;
import ru.yandex.misc.time.MoscowTime;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ScheduleWakeUpSchedulersTask extends CronTask {
    private final WakeUpPushManager manager;

    public ScheduleWakeUpSchedulersTask(WakeUpPushManager manager) {
        this.manager = manager;
    }

    @Override
    public Schedule cronExpression() {
        return new ScheduleWithRetry(new ScheduleCron("11 0,12 * * *", MoscowTime.TZ), 5);
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        manager.scheduleWakeUpPushSchedulers();
    }
}
