package ru.yandex.chemodan.app.worker2.wakeup;

import org.joda.time.Duration;

import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleExponential;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class SendWakeUpPushTask extends OnetimeTaskSupport<SendWakeUpPushTask.Params> {
    private final WakeUpPushManager manager;

    public SendWakeUpPushTask(PassportUid uid) {
        super(new Params(uid));
        this.manager = null;
    }

    public SendWakeUpPushTask(WakeUpPushManager manager) {
        super(Params.class);
        this.manager = manager;
    }

    @Override
    protected void execute(Params params, ExecutionContext context) {
        manager.sendWakeUpPushes(params.uid);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(2);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleExponential(Duration.standardMinutes(2), 5);
    }

    @BenderBindAllFields
    static class Params {
        private final PassportUid uid;

        private Params(PassportUid uid) {
            this.uid = uid;
        }
    }
}
