package ru.yandex.chemodan.app.worker2.wakeup;

import java.util.concurrent.TimeUnit;

import net.jodah.failsafe.RetryPolicy;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.worker2.Worker2BazingaCoreContextConfiguration;
import ru.yandex.chemodan.app.worker2.xiva.XivaPushContextConfiguration;
import ru.yandex.chemodan.app.worker2.xiva.XivaPushSender;
import ru.yandex.chemodan.util.yt.YtHelper;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.impl.YtUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
@Import({
        XivaPushContextConfiguration.class,
        Worker2BazingaCoreContextConfiguration.class
})
public class WakeUpPushContextConfig {
    @Value("${worker.yt.http.proxy}")
    private String ytHttpProxyUrl;

    @Value("${worker.java-stat.user.yt.token}")
    private String ytUserOauthToken;

    @Value("${worker.java-stat.yt.operation.retry.count}")
    private int ytOperationRetryCount;

    @Value("${worker.java-stat.yt.operation.retry.delay}")
    private Duration ytOperationRetryDelay;

    @Value("${worker.wake-up-push.yt.remove-data-older-than-days}")
    private int removeDataOlderThanDays;

    @Value("${worker.wake-up-push.yt.aggregate-data-for-last-days}")
    private int aggregateDataForLastDays;

    @Value("${worker.wake-up-push.scheduling-batch-send-duration}")
    private Duration schedulingBatchSendDuration;

    @Value("${worker.wake-up-push.scheduling-batch-size}")
    private int schedulingBatchSize;

    @Value("${worker.wake-up-push.send-dry-run}")
    private boolean sendDryRun;

    private final DynamicProperty<Boolean> batchSendEnabled =
            new DynamicProperty<>("worker.wake-up-push.batch-send-enabled", false);

    private final BazingaTaskManager bazingaTaskManager;

    private final XivaPushSender xivaPushSender;

    @Autowired
    public WakeUpPushContextConfig(BazingaTaskManager bazingaTaskManager, XivaPushSender xivaPushSender) {
        this.bazingaTaskManager = bazingaTaskManager;
        this.xivaPushSender = xivaPushSender;
    }

    @Bean
    public UpdateIosUsersTask updateIosUsersTask() {
        return new UpdateIosUsersTask(wakeUpPushManager());
    }

    @Bean
    public ScheduleWakeUpSchedulersTask scheduleWakeUpSchedulersTask() {
        return new ScheduleWakeUpSchedulersTask(wakeUpPushManager());
    }

    @Bean
    public ScheduleWakeUpPushRangeTask scheduleWakeUpPushRangeTask() {
        return new ScheduleWakeUpPushRangeTask(wakeUpPushManager());
    }

    @Bean
    public SendWakeUpPushTask sendWakeUpPushTask() {
        return new SendWakeUpPushTask(wakeUpPushManager());
    }

    @Bean
    public WakeUpPushManager wakeUpPushManager() {
        return new WakeUpPushManager(javaStatYtHelper(), bazingaTaskManager,
                xivaPushSender,
                removeDataOlderThanDays,
                aggregateDataForLastDays,
                schedulingBatchSendDuration,
                schedulingBatchSize,
                sendDryRun,
                batchSendEnabled
        );
    }

    @Bean
    protected YtHelper javaStatYtHelper() {
        return new YtHelper(javaStatYtClient(), ytMemoriesOperationRetryPolicy());
    }

    @Bean
    protected Yt javaStatYtClient() {
        return YtUtils.http(ytHttpProxyUrl, ytUserOauthToken);
    }

    @Bean
    protected RetryPolicy ytMemoriesOperationRetryPolicy() {
        return new RetryPolicy()
                .withMaxRetries(ytOperationRetryCount)
                .withDelay(ytOperationRetryDelay.getMillis(), TimeUnit.MILLISECONDS);
    }
}
