package ru.yandex.chemodan.app.worker2.wakeup;

import java.util.function.Consumer;
import java.util.function.Function;

import org.jetbrains.annotations.NotNull;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function0V;
import ru.yandex.chemodan.app.worker2.xiva.XivaPushSender;
import ru.yandex.chemodan.util.yt.YtHelper;
import ru.yandex.chemodan.xiva.XivaClient;
import ru.yandex.chemodan.xiva.XivaPushService;
import ru.yandex.chemodan.xiva.XivaSingleTokenClient;
import ru.yandex.chemodan.xiva.XivaSubscription;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.tables.YTableEntryType;
import ru.yandex.inside.yt.kosher.tables.YtTables;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.doAnswer;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class WakeUpPushManagerTestHelper {

    public static WakeUpPushManager mockDependeniesForWakeUpManager(XivaSingleTokenClient xivaSingleTokenClient,
            ListF<WakeUpPushManager.UidAndLastSeen> uidAndLastSeenList, boolean batchSendEnabled)
    {
        final YtHelper yt = mockYt(uidAndLastSeenList);

        final BazingaTaskManager bazingaTaskManager = mock(BazingaTaskManager.class);
        final XivaClient xivaClient = mockXivaClient(xivaSingleTokenClient);
        XivaPushSender xivaPushSender = new XivaPushSender(xivaClient, 1);
        final WakeUpPushManager wakeUpPushManager = new WakeUpPushManager(yt, bazingaTaskManager, xivaPushSender, 10,
                30, Duration.standardHours(6), 5000, false,
                DynamicProperty.cons("batchSendEnabled", batchSendEnabled));
        mockBazinga(bazingaTaskManager, wakeUpPushManager);
        return wakeUpPushManager;
    }

    private static void mockBazinga(BazingaTaskManager bazingaTaskManager, WakeUpPushManager wakeUpPushManager) {
        final ScheduleWakeUpPushRangeTask scheduleWakeUpPushRangeTask =
                new ScheduleWakeUpPushRangeTask(wakeUpPushManager);
        final SendWakeUpPushTask sendWakeUpPushTask = new SendWakeUpPushTask(wakeUpPushManager);
        final ExecutionContext executionContext = mock(ExecutionContext.class);
        doAnswer(invocation -> {
            final ScheduleWakeUpPushRangeTask.Params params =
                    invocation.<ScheduleWakeUpPushRangeTask>getArgument(0).getParametersTyped();
            scheduleWakeUpPushRangeTask.execute(params, executionContext);
            return null;
        }).when(bazingaTaskManager).schedule(any(ScheduleWakeUpPushRangeTask.class), any(Instant.class));
        doAnswer(invocation -> {
            final SendWakeUpPushTask.Params params =
                    invocation.<SendWakeUpPushTask>getArgument(0).getParametersTyped();
            sendWakeUpPushTask.execute(params, executionContext);
            return null;
        }).when(bazingaTaskManager).schedule(any(SendWakeUpPushTask.class));
    }

    @NotNull
    private static XivaClient mockXivaClient(XivaSingleTokenClient xivaSingleTokenClient) {
        final XivaClient xivaClient = mock(XivaClient.class);
        when(xivaClient.toSingleTokenClient(any(String.class))).thenReturn(xivaSingleTokenClient);
        when(xivaSingleTokenClient.list(any(PassportUid.class), any(String.class)))
                .thenReturn(
                        Cf.list(XivaSubscription.builder().id("123").platform(XivaPushService.APNS.value()).build()));
        return xivaClient;
    }

    @NotNull
    private static YtHelper mockYt(ListF<WakeUpPushManager.UidAndLastSeen> uidAndLastSeenList) {
        final YtHelper yt = mock(YtHelper.class);
        doAnswer(invocation -> {
            invocation.<Function0V>getArgument(0).apply();
            return null;
        }).when(yt).runWithRetries(any(Function0V.class));
        final YtTables tables = mock(YtTables.class);
        when(yt.tables()).thenReturn(tables);
        doAnswer(invocation -> {
            uidAndLastSeenList.forEach(invocation.<Consumer>getArgument(2)::accept);
            return null;
        }).when(tables).read(any(YPath.class), any(YTableEntryType.class), any(Consumer.class));
        doAnswer(invocation -> {
            invocation.<Function>getArgument(2).apply(uidAndLastSeenList.iterator());
            return null;
        }).when(tables).read(any(YPath.class), any(YTableEntryType.class), any(Function.class));
        return yt;
    }
}
