package ru.yandex.chemodan.app.worker2.xiva;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.xiva.XivaClientContextConfiguration;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
@Import(XivaClientContextConfiguration.class)
public class XivaPushContextConfiguration {
    @Value("${push-sender.max-pool-size}")
    private int maxPoolSize;

    @Autowired
    private XivaClientContextConfiguration clientConfig;

    @Bean
    public XivaPushSender xivaPushSender() {
        return new XivaPushSender(clientConfig.mainXivaPushClient(), maxPoolSize);
    }
}
