package ru.yandex.chemodan.app.worker2.xiva;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.util.JsonAssert;
import ru.yandex.chemodan.xiva.XivaSubscription;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.test.Assert;

import static ru.yandex.bolts.collection.Option.empty;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class XivaPushSenderTest {
    @Test
    public void testWakeUpPushContents() {
        String actualJson = new String(XivaPushSender.buildWakeUpEvent(new PassportUid(1L),
                new XivaSubscription("1234", empty(), empty(), empty()),
                "random"
        ).serializeBody());
        JsonAssert.equals(
                ("{'payload':'{\\'root\\':{\\'session_id\\':\\'1:random\\',\\'tag\\':\\'wake_up\\'}}'"
                        + ",'recipients':[{'1':'1234'}]}")
                        .replace("'", "\""),
                actualJson
        );
    }

    @Test
    public void testSplitToMapsWithOneSubscriptionForEveryUid() {
        PassportUid uid1 = new PassportUid(1L);
        final XivaSubscription subscription11 = new XivaSubscription("11", empty(), empty(), empty());
        final XivaSubscription subscription12 = new XivaSubscription("12", empty(), empty(), empty());
        ListF<XivaSubscription> subscriptionList1 = Cf.list(subscription11, subscription12);

        PassportUid uid2 = new PassportUid(2L);
        final XivaSubscription subscription21 = new XivaSubscription("21", empty(), empty(), empty());
        ListF<XivaSubscription> subscriptionList2 = Cf.list(subscription21);

        final ListF<MapF<PassportUid, XivaSubscription>> actual = XivaPushSender
                .splitToMapsWithOneSubscriptionForEveryUid(Cf.map(uid1, subscriptionList1, uid2, subscriptionList2));

        final MapF<PassportUid, XivaSubscription> map1 = Cf.map(uid1, subscription11, uid2, subscription21);
        final MapF<PassportUid, XivaSubscription> map2 = Cf.map(uid1, subscription12);
        final ListF<MapF<PassportUid, XivaSubscription>> expected = Cf.list(map1, map2);
        Assert.assertListsEqual(actual, expected);
    }
}
