# encoding: UTF-8

import typing as t

_T = t.TypeVar('T')


class Page(t.Generic[_T]):
    def __init__(self, items, offset, size, total):
        # type: (t.Iterable[_T], int, int, int) -> None

        self.items = list(items)  # type: t.List[_T]
        self.offset = offset  # type: int
        self.size = size  # type: int
        self.total = total  # type: int


class Pageable(object):
    def __init__(self, offset, size):
        # type: (int, int) -> None

        self.offset = offset  # type: int
        self.size = size  # type: int

    @property
    def end_offset(self):
        return self.offset + self.size
