# encoding: UTF-8

import functools

import flask

G_REQUIRE_MASTER_SESSION = '_master_session_required'


def master_session(func):
    @functools.wraps(func)
    def master_session_wrapper(*args, **kwargs):
        require_master_session()
        return func(*args, **kwargs)

    master_session_wrapper.__require_master_session__ = True
    return master_session_wrapper


def require_master_session():
    setattr(flask.g, G_REQUIRE_MASTER_SESSION, True)


class SessionSelector(object):
    _FLAG_NAME = '_master_session_required'

    def __init__(
            self,
            master_session_factory,
            slave_session_factory
    ):
        self._master_session_factory = master_session_factory
        self._slave_session_factory = slave_session_factory

    def __call__(self, master_required=None):
        if master_required is None:
            master_required = getattr(flask.g, G_REQUIRE_MASTER_SESSION, False)

        if master_required:
            return self._master_session_factory()
        else:
            return self._slave_session_factory()
