# encoding: UTF-8

import flask


class InjectionError(Exception):
    pass


class Injected(object):
    def __init__(self, name):
        self.name = name

    def __get__(self, instance, owner):
        if instance is None:
            return self
        else:
            return inject(self.name)


def inject(name, app=None):
    try:
        app = app or flask.current_app
        return app.extensions[name]
    except KeyError:
        raise InjectionError('Extension "%s" not found' % name)


def register_injection(app, name, value):
    if name in app.extensions:
        raise ValueError('Extension \'%s\' duplicates another one' % name)

    app.extensions[name] = value
