# encoding: UTF-8

import flask


class PluginBase(object):
    def __init__(self, app=None):
        self.app = None  # type: flask.Flask
        if app is not None:
            self.init_app(app)

    def init_app(self, app):
        self.app = app
        self._do_init_app()

    def _do_init_app(self):
        raise NotImplementedError
