# encoding: UTF-8

import functools

from appcore.security.helpers import require_authenticated_client
from appcore.security.helpers import require_authenticated_user
from appcore.security.helpers import require_client_scopes
from appcore.struct import maybe_list


def authenticated_client(scopes=None, requires_all=False, fail_with_404=False):
    scopes = maybe_list(scopes or [])

    def authenticated_client_wrapper(func):
        @functools.wraps(func)
        def authenticated_client_wrapped(*args, **kwargs):
            require_authenticated_client(fail_with_404)
            require_client_scopes(scopes, requires_all, fail_with_404)
            return func(*args, **kwargs)

        authenticated_client_wrapped.__authenticated_client__ = dict(
            scopes=scopes,
            requires_all=requires_all,
        )
        return authenticated_client_wrapped

    return authenticated_client_wrapper


def authenticated_user(func, fail_with_404=False):
    @functools.wraps(func)
    def authenticated_user_wrapped(*args, **kwargs):
        require_authenticated_user(fail_with_404)
        return func(*args, **kwargs)

    authenticated_user_wrapped.__authenticated_user__ = True
    return authenticated_user_wrapped
