# encoding: UTF-8

import marshmallow as ma


class RemoteIdentitySchema(ma.Schema):
    remote_addr = ma.fields.String(required=True)
    real_ip = ma.fields.String(required=True)


class AuthIdentitySchema(ma.Schema):
    client_id = ma.fields.String(required=True, allow_none=True)
    user_id = ma.fields.Integer(required=True, allow_none=True)
    user_ip = ma.fields.String(required=True, allow_none=True)
    scopes = ma.fields.List(ma.fields.Field(), required=True)


class SecurityContextSchema(ma.Schema):
    remote_identity = ma.fields.Nested(RemoteIdentitySchema(), required=True)
    auth_identity = ma.fields.Nested(AuthIdentitySchema(), required=True)
