# encoding: UTF-8

from werkzeug.exceptions import NotFound

from appcore.security.exceptions import NoRequiredScopesError
from appcore.security.exceptions import UnauthenticatedClientError
from appcore.security.exceptions import UnauthenticatedUserError
from appcore.security.plugin import security_context


def require_authenticated_client(fail_with_404=False, ctx=security_context):
    if not ctx.auth_identity.is_authenticated_client:
        if fail_with_404:
            raise NotFound()
        else:
            raise UnauthenticatedClientError()


def require_client_scopes(
        scopes,
        requires_all=False,
        fail_with_404=False,
        ctx=security_context,
):
    if not ctx.auth_identity.has_client_scopes(scopes, requires_all):
        if fail_with_404:
            raise NotFound()
        else:
            raise NoRequiredScopesError(scopes, requires_all)


def require_authenticated_user(fail_with_404=False, ctx=security_context):
    if not ctx.auth_identity.is_authenticated_user:
        if fail_with_404:
            raise NotFound()
        else:
            raise UnauthenticatedUserError()
