# encoding: UTF-8

import flask

from appcore.security.exceptions import UnauthenticatedAccessError
from appcore.security.model import HEADER_REAL_IP, HEADER_USER_IP
from appcore.security.model import RemoteIdentity


class IdentifyingStrategy(object):
    def identify_remote(self, request):
        raise NotImplementedError


class StandardIdentifyingStrategy(IdentifyingStrategy):
    def __init__(self, ignored_endpoints=None):
        self.ignored_endpoints = ignored_endpoints or []

    def identify_remote(self, request):
        # type: (flask.Request) -> RemoteIdentity

        real_ip = request.headers.get(HEADER_REAL_IP)
        if not real_ip and request.endpoint not in self.ignored_endpoints:
            raise UnauthenticatedAccessError(
                'X-Real-IP header lost. '
                'It seems like You trying direct access API '
                'bypassing balancer. '
                'Please provide header manually if You want use API this way.'
            )

        user_ip = request.headers.get(HEADER_USER_IP)

        return RemoteIdentity(
            remote_addr=request.remote_addr,
            real_ip=real_ip,
            user_ip=user_ip,
        )
