# encoding: UTF-8

import typing as t

HEADER_AUTHORIZATION = 'Authorization'
HEADER_REAL_IP = 'X-Real-IP'
HEADER_USER_IP = 'X-User-IP'


class RemoteIdentity(object):
    def __init__(
            self,
            remote_addr,  # type: str
            real_ip,  # type: str
            user_ip,  # type: str
    ):
        self.remote_addr = remote_addr  # type: str
        self.real_ip = real_ip  # type: str
        self.user_ip = user_ip  # type: str


class AuthIdentity(object):
    def __init__(
            self,
            client_id,  # type: t.Optional[str]
            client_scopes,  # type: t.Set[str]
            user_id,  # type: t.Optional[int]
    ):
        self.client_id = client_id  # type: t.Optional[str]
        self.client_scopes = client_scopes  # type: t.Set[t.Any]
        self.user_id = user_id  # type: t.Optional[int]

    @property
    def is_authenticated_client(self):
        return self.client_id is not None

    def has_client_scopes(self, scopes, requires_all=False):
        if not scopes:
            return True

        scopes_exists = [
            scope in self.client_scopes
            for scope in scopes
        ]
        scopes_agg_func = all if requires_all else any

        return scopes_agg_func(scopes_exists)

    @property
    def is_authenticated_user(self):
        return self.user_id is not None


class SecurityContext(object):
    def __init__(
            self,
            remote_identity,  # type: RemoteIdentity
            auth_identity,  # type: AuthIdentity
    ):
        self.remote_identity = remote_identity  # type: RemoteIdentity
        self.auth_identity = auth_identity  # type: AuthIdentity
