# encoding: UTF-8

import flask
import typing as t

from appcore.security.exceptions import UnauthenticatedAccessError
from appcore.security.model import AuthIdentity
from appcore.security.model import HEADER_AUTHORIZATION
from appcore.security.model import RemoteIdentity


class AuthProvider(object):
    @staticmethod
    def _get_authorization_header(request):
        # type: (flask.Request) -> t.Optional[str]

        return request.headers.get(HEADER_AUTHORIZATION)

    @staticmethod
    def _get_authorization_tokens(request):
        # type: (flask.Request) -> t.List[str]

        header = request.headers.get(HEADER_AUTHORIZATION)
        return header.split() if header else []

    @staticmethod
    def _validate_uid(uid):
        if uid is None:
            return None

        try:
            return int(uid)
        except ValueError:
            raise UnauthenticatedAccessError('Invalid used id')

    def authenticate_request(self, request, remote_identity):
        # type: (flask.Request, RemoteIdentity) -> t.Optional[AuthIdentity]

        raise NotImplementedError
