# encoding: UTF-8


def coalesce(*values):
    for value in values:
        if value:
            return value

    if values:
        return values[-1]
    else:
        return None


def maybe_list(value):
    if isinstance(value, list):
        return value
    else:
        return [value]


def expect_type(value, types):
    types = tuple(maybe_list(types))
    if not isinstance(value, types):
        raise ValueError('Got value of unexpected type')
    return value
