# encoding: UTF-8

import functools

import transaction
import transaction.interfaces
import werkzeug.local

from appcore.injection import inject
from appcore.injection import register_injection
from appcore.plugin import PluginBase


class TxPlugin(PluginBase):
    TX_MANAGER_INJ = 'tx_manager'

    def _do_init_app(self):
        self.tx_manager = transaction.ThreadTransactionManager()
        self.tx_manager.explicit = True

        register_injection(self.app, self.TX_MANAGER_INJ, self.tx_manager)

        self.app.before_request(self._tx_begin)
        self.app.teardown_request(self._tx_finalize)
        self.app.teardown_appcontext(self._tx_finalize)

    # noinspection PyMethodMayBeStatic
    def _tx_begin(self):
        tx_manager.begin()

    def _tx_finalize(self, _):
        # noinspection PyBroadException
        try:
            tx_manager.abort()
        except transaction.interfaces.NoTransaction:
            pass
        except BaseException:
            self.app.logger.exception('Failed to finalize transaction')


tx_manager = werkzeug.local.LocalProxy(
    functools.partial(inject, TxPlugin.TX_MANAGER_INJ),
)  # type: transaction.TransactionManager
