# encoding: UTF-8

import ylog.context
from requests import Response, PreparedRequest
from ws_properties.utils.logs import get_logger_for_instance


class ResponseLoggerHook(object):
    DEFAULT_HIDDEN_HEADERS = (
        'X-Ya-Service-Ticket',
        'X-Ya-User-Ticket',
        'Authorization',
    )
    HIDDEN_HEADERS_PLACEHOLDER = '******'

    def __init__(self, logger, hidden_headers=None):
        self.__logger = logger or get_logger_for_instance(self)
        self.__hidden_headers = set(
            hidden_headers or self.DEFAULT_HIDDEN_HEADERS,
        )

    def _hide_headers(self, headers):
        headers = headers.copy()
        for header in self.__hidden_headers:
            if header in headers:
                headers[header] = self.HIDDEN_HEADERS_PLACEHOLDER
        return dict(headers)

    def __call__(self, response, *args, **kwargs):
        request = response.request  # type: PreparedRequest
        data = dict(
            request=dict(
                method=request.method,
                url=request.url,
                headers=self._hide_headers(request.headers),
            ),
            response=dict(
                status_code=response.status_code,
                reason=response.reason,
                headers=self._hide_headers(response.headers),
            )
        )
        with ylog.context.log_context(requests=data):
            self.__logger.info('Requests call')
