#!/usr/bin/env bash

VERSION=1.0.7.2

set -e

ROOT=$(dirname $0)

function build_image() {
    docker build $3 --target "$2" -t "$1" -f "$ROOT/Dockerfile" "$ROOT" || exit 1
}

# Run unittests

echo '#!/usr/bin/env bash' > push_images.sh
chmod +x push_images.sh

REGISTRY=registry.yandex.net
PREFIX=workspace/any/dns-hosting
IMAGE=unittest
TAG="$REGISTRY/$PREFIX/$IMAGE:$VERSION"
build_image "$TAG" "$IMAGE" "$@"

# Building images

REGISTRY=registry.yandex.net
PREFIX=workspace/deploy/dns-hosting
IMAGE=dns-server-nsd
TAG="$REGISTRY/$PREFIX/$IMAGE:$VERSION"

build_image "$TAG" "$IMAGE"

echo "docker push $TAG" >> push_images.sh

echo ========================================

REGISTRY=registry.yandex.net
PREFIX=workspace/rtc/dns-hosting
IMAGE=dns-master-dns
TAG="$REGISTRY/$PREFIX/$IMAGE:$VERSION"

build_image "$TAG" "$IMAGE"

echo "docker push $TAG" >> push_images.sh

echo ========================================

REGISTRY=registry.yandex.net
PREFIX=workspace/rtc/dns-hosting
IMAGE=dns-master-http
TAG="$REGISTRY/$PREFIX/$IMAGE:$VERSION"

build_image "$TAG" "$IMAGE"

echo "docker push $TAG" >> push_images.sh

echo ========================================

REGISTRY=registry.yandex.net
PREFIX=workspace/rtc/dns-hosting
IMAGE=migrator
TAG="$REGISTRY/$PREFIX/$IMAGE:$VERSION"

build_image "$TAG" "$IMAGE"

echo "docker push $TAG" >> push_images.sh

echo ========================================

REGISTRY=registry.yandex.net
PREFIX=workspace/deploy/dns-hosting
IMAGE=dns-api
TAG="$REGISTRY/$PREFIX/$IMAGE:$VERSION"

build_image "$TAG" "$IMAGE"

echo "docker push $TAG" >> push_images.sh

echo ========================================

REGISTRY=registry.yandex.net
PREFIX=workspace/deploy/dns-hosting
IMAGE=dns-master
TAG="$REGISTRY/$PREFIX/$IMAGE:$VERSION"

build_image "$TAG" "$IMAGE"

echo "docker push $TAG" >> push_images.sh
