from typing import List, Dict

from clients.base import BaseHttpClient
from settings import config


class CatalogHttpClient(BaseHttpClient):
    base_url = config.connect_host
    tvm_client_id = config.connect_tvm_client
    service = "connect"

    async def search_domains(self, domains: List[str]) -> Dict[str, List]:
        """
        возвращается такой dict
        {
            '3377733.ru': [{'org_id': 7139555, 'owned': True}, {...}],
            'domain_name': [{'org_id': org_id, 'owned': True}],
            ...
        }
        """

        data = {
            'domains': domains,
            'fields': [
                "org_id",
                "owned",
            ],
        }

        return await self.post(path='/v11/domains/search', json=data)
