from typing import Dict

from clients.base import BaseHttpClient
from settings import config


class DNSAPIHttpClient(BaseHttpClient):
    base_url = config.dns_api_host
    tvm_client_id = config.dns_api_tvm_client
    raise_for_status = True
    service = "dns_api"

    async def enable_domain(self, domain_name: str, org_id: str) -> Dict:
        data = {
            "name": f'{domain_name}.',
        }
        resp = await self.post(
            path='/domains',
            json=data,
            headers=self.get_headers(org_id),
        )
        return resp

    async def get_domain(self, domain_name: str, org_id: str):
        resp = await self.get(
            path=f'/domains/{domain_name}',
            headers=self.get_headers(org_id),
        )
        return resp

    @staticmethod
    def get_headers(org_id: str) -> Dict:
        return {
            "X-Org-ID": org_id,
            "X-Real-IP": "127.0.0.1",
        }
