from functools import wraps

import yt.wrapper as yt
from yt.wrapper import YtClient

from settings import config
from utils.utils import sync_to_async


class AsyncYtClient:
    def __init__(self):
        self.client = YtClient(token=config.yt.token, proxy=config.yt.locke_cluster)

    @sync_to_async
    def exists(self, *args, **kwargs):
        return yt.exists(*args, client=self.client, **kwargs)

    @sync_to_async
    def set(self, *args, **kwargs):
        return yt.set(*args, client=self.client, **kwargs)

    @sync_to_async
    def get(self, *args, **kwargs):
        return yt.get(*args, client=self.client, **kwargs)

    @sync_to_async
    def remove(self, *args, **kwargs):
        return yt.remove(*args, client=self.client, **kwargs)

    @sync_to_async
    def create(self, *args, **kwargs):
        return yt.create(*args, client=self.client, **kwargs)

    @sync_to_async
    def lock(self, *args, **kwargs):
        return yt.lock(*args, client=self.client, **kwargs)

    async def create_locke_if_not_exist(
        self, path: str = None, type: str = 'map_node', recursive: bool = False, timeout: int = None
    ) -> bool:
        if not await self.exists(path):
            attributes = {"expiration_timeout": timeout} if timeout else {}
            await self.create(path=path, type=type, recursive=recursive, attributes=attributes)
            return True
        return False


yt_client = AsyncYtClient()


def set_lock(func):
    @wraps(func)
    async def wrapped(*args):
        path = f'{config.yt.locke_path}/{config.env}/{func.__qualname__.lower()}'
        # таймаут сделал максимум для задач - 6 часов = 21600000 msec
        if not await yt_client.create_locke_if_not_exist(path, recursive=True, timeout=21600000):
            return
        try:
            return await func(*args)
        finally:
            await yt_client.remove(path=path, force=True)

    return wrapped
