import asyncio

import pytz
from aiohttp import web
from apscheduler.schedulers.asyncio import AsyncIOScheduler
from loguru import logger
from setproctitle import setproctitle

from app import init_app
from settings import config
from tasks import tasks
from utils.logconf import initialize_logging


def main():
    initialize_logging()
    logger.info('launching app')
    setproctitle("dns_cron")

    loop = asyncio.get_event_loop()
    scheduler = AsyncIOScheduler(logger=logger, timezone=pytz.timezone('Europe/Moscow'))
    # FIXME: не очень нравится как сделал таски, надо будет улучить работу с ними и сделать свой шедулер не по расписанию
    for task in tasks:
        init_task = task(config)
        scheduler.add_job(init_task.run, **init_task.get_scheduler_settings())

    scheduler.start()
    app = init_app()
    runner = web.AppRunner(app)
    loop.run_until_complete(runner.setup())
    site = web.TCPSite(runner=runner, host="::", port=8080)
    loop.run_until_complete(site.start())

    try:
        loop.run_forever()
    except (KeyboardInterrupt, SystemExit):
        scheduler.shutdown()
        logger.info("stop app")


if __name__ == '__main__':
    main()
