import socket

from pydantic import BaseSettings, Field, BaseModel
from tvmauth import BlackboxTvmId


class LoggingSettings(BaseSettings):
    file_enabled: bool = True
    file_path: str = 'dns_cron.log'
    file_rotation_rule: str = '500 MB'
    file_retention_count: int = 5

    stdout_enabled: bool = True
    stdout_json_formatted: bool = False

    class Config:
        env_prefix = 'log_'


class YTSettings(BaseSettings):
    token: str
    locke_cluster: str = 'locke'
    locke_path: str = '//home/deploy/workspace/dns-hosting'

    class Config:
        env_prefix = 'yt_'


class SchedulerSettings(BaseModel):
    hours: float = 6.0
    trigger: str = "interval"
    start_now: bool = True


class BaseTaskSettings(BaseSettings):
    scheduler: SchedulerSettings = SchedulerSettings()
    enabled = True
    dig_timeout: int = 1
    dig_tries: int = 2
    chunk_size: int = 120  # количество доменов, которые за раз отправляем в ручку поиска директории
    date: str = ""
    days: int = None


class CheckCurrentYearSettings(BaseTaskSettings):
    enabled: bool = True

    class Config:
        env_prefix = 'curr_years_task_'


class CheckLatestYearsSettings(BaseTaskSettings):
    scheduler: SchedulerSettings = SchedulerSettings(hours=1.5)
    enabled = True
    domains_offset: int = 100000
    dig_tries: int = 1

    class Config:
        env_prefix = 'latest_years_task_'


class Settings(BaseSettings):
    env: str
    tvm_token: str = Field(env="TVMTOOL_LOCAL_AUTHTOKEN")

    dns_api_host: str = 'https://test.dns-hosting.ws.yandex.net/api/v1'
    dns_api_tvm_client: str = '2013732'  # test

    connect_host: str = 'https://api-internal-test.directory.ws.yandex.net'
    connect_tvm_client: str = '2000204'  # test

    blackbox_client: BlackboxTvmId = BlackboxTvmId.Test
    hostname: str = socket.gethostname()
    useragent: str = "DNS-hosting cron"

    logging: LoggingSettings = LoggingSettings()
    yt: YTSettings = YTSettings()

    check_current_year: CheckCurrentYearSettings = CheckCurrentYearSettings()
    check_latest_years: CheckLatestYearsSettings = CheckLatestYearsSettings()
