from tvmauth import BlackboxTvmId

from .base import Settings as BaseSettings, LoggingSettings


class Settings(BaseSettings):
    dns_api_host: str = 'https://prod.dns-hosting.ws.yandex.net/api/v1'
    dns_api_tvm_client: str = '2001640'

    connect_host: str = 'https://api-internal.directory.ws.yandex.net'
    connect_tvm_client: str = '2000205'

    blackbox_client: BlackboxTvmId = BlackboxTvmId.Prod

    logging: LoggingSettings = LoggingSettings()
    logging.file_path = "/app/log/dns_cron.log"
    logging.file_enabled = True
    logging.stdout_json_formatted = True
