import enum

from lib.sendr_qstats import AggSuff, Counter, Gauge, Histogram, IntSuff, MetricsRegistry, MetricSuffix, Summary
from settings import config

REGISTRY = MetricsRegistry(ctype=config.env)

STATS_TASK_BUCKETS = (
    0.0, .005, .01, .025, .05, .075, .1, .25, .5, .75, 1.0, 2.5, 5.0, 7.5, 10.0,
    12.5, 15.0, 17.5, 20.0, 22.5, 25.0, 27.5, 30.0, 60.0, 120.0, 180.0, 400.0, 600.0,
    1200.0, 2400.0, 3000.0, 3600.0, 4200.0, 4800.0, 7200., 21600.0,
)

STATS_RESPONSE_TIME_BUCKETS = (
    0.0, .005, .01,
    .025, .05, .075, .1,
    .25, .5, .75, 1.0,
    2.5, 5.0, 7.5, 10.0, 12.5, 15, 17.5, 20,
    25, 30, 60
)


class Status(str, enum.Enum):
    success = "success"
    failed = "failed"


class DomainStatus(str, enum.Enum):
    created = "created"  # добавленных
    need_created = "need_created"  # не существующих в dns-api но должны быть добавлены
    processed = "processed"  # обработанных
    delegated = "delegated"  # делегированных на наши dns
    exist = "exist"  # существующих в коннекте


ABS_MAX_SUFF = MetricSuffix(
    IntSuff.absolute.value,
    AggSuff.max.value,
    AggSuff.max.value,
    AggSuff.trnsp.value,
)

# для http клиентов
http_client_response_short_status = Counter(
    'response_status',
    labelnames=('service', 'status'),
    registry=REGISTRY,
)

http_client_response_status = Counter(
    'response_method_code',
    labelnames=('service', 'status'),
    registry=REGISTRY,
)

http_client_method_response_time = Histogram(
    'response_method_time',
    buckets=STATS_RESPONSE_TIME_BUCKETS,
    labelnames=('service', 'method'),
    registry=REGISTRY,
)

http_client_method_response_short_status = Counter(
    'response_method_status',
    labelnames=('service', 'method', 'status'),
    registry=REGISTRY,
)

http_client_response_time = Histogram(
    'response_time',
    buckets=STATS_RESPONSE_TIME_BUCKETS,
    labelnames=('service',),
    registry=REGISTRY,
)

# количество запросов к сервису
http_client_request_count = Counter(
    'request_count',
    labelnames=('service', ),
    registry=REGISTRY,
)
# статус запроса - success или failed, сумма равна http_client_request_count
http_client_request_status = Counter(
    'request_status',
    labelnames=('service', 'status'),
    registry=REGISTRY,
)


# выполняемых тасок сейчас
tasks_count_gauge = Gauge(
    'tasks_running',
    labelnames=('task_name', ),
    registry=REGISTRY,
)

tasks_time = Histogram(
    'tasks_time',
    labelnames=('task_name',),
    buckets=STATS_TASK_BUCKETS,
    registry=REGISTRY,
)

# "success"/"failed"
tasks_counter = Counter(
    'tasks',
    labelnames=('task_name', 'status', ),
    registry=REGISTRY,
)

# DomainStatus
domains_gauge = Gauge(
    'domains',
    labelnames=('task_name', 'status', ),
    registry=REGISTRY,
)

domains_sum = Summary(
    'domains_summ',
    labelnames = ('task_name', 'status',),
    registry = REGISTRY,
)
