from tvm2 import TVM2

from settings import config


class TVM2Error(Exception):
    pass


def get_tvm_client():
    return TVM2(
        client_id=config.dns_api_tvm_client,
        secret=config.tvm_token,
        blackbox_client=config.blackbox_client,
    )


tvm_client = get_tvm_client()


async def get_service_ticket(client_id: str) -> str:
    service_ticket = await tvm_client.get_service_ticket(client_id)

    if not service_ticket:
        raise TVM2Error('Failed to get TVM service ticket from Blackbox')
    return service_ticket
