#!/usr/bin/env python2
# encoding: UTF-8

from dns_hosting.services.support.hub import set_hub_logging

set_hub_logging()

import psycogreen.gevent

psycogreen.gevent.patch_psycopg()

import atexit

from ws_properties.conversion.service import StandardConversionService
from ws_properties.environ.environment import StandardEnvironment

from appcore.injection import inject
from dns_hosting.app_factory import create_app


def setup_profiler():
    import GreenletProfiler

    GreenletProfiler.set_clock_type('cpu')
    GreenletProfiler.start()

    @atexit.register
    def _stop_profiling():
        GreenletProfiler.stop()
        stats = GreenletProfiler.get_func_stats()
        stats.save('stats.callgrind', type='callgrind')


# setup_profiler()

environment = StandardEnvironment()
environment.conversion_service = StandardConversionService()
environment.activate_profiles()

application = create_app(environment)
cli = inject('cli', application)

if __name__ == '__main__':
    cli()
