CREATE TABLE IF NOT EXISTS domains (
  id               SERIAL PRIMARY KEY,
  name             VARCHAR(255) NOT NULL,
  serial           INT          NOT NULL,
  org_id           INT, -- TODO make not nullable after full migration from PDD
  revision         BIGINT, -- TODO make not nullable after full migration from PDD
  is_technical     BOOLEAN      NOT NULL,
  pdd_sync_enabled BOOLEAN      NOT NULL, -- TODO remove after full migration from PDD
  pdd_domain_id    INT, -- TODO remove after full migration from PDD
  CONSTRAINT c_lowercase_name CHECK (name :: TEXT = LOWER(name :: TEXT)),
  CONSTRAINT c_check_org_id_revision CHECK (
    pdd_sync_enabled OR (org_id IS NOT NULL AND revision IS NOT NULL)
  ),
  CONSTRAINT c_check_pdd_domain_id CHECK (
    NOT pdd_sync_enabled OR pdd_domain_id IS NOT NULL
  )
);

CREATE UNIQUE INDEX IF NOT EXISTS idx_domain_name
  ON domains
  USING btree (name);

CREATE UNIQUE INDEX IF NOT EXISTS idx_pdd_domain_id
  ON domains
  USING btree (pdd_domain_id);

CREATE TABLE IF NOT EXISTS records (
  id        BIGSERIAL PRIMARY KEY,
  domain_id INT            NOT NULL,
  name      VARCHAR(255)   NOT NULL,
  type      VARCHAR(10)    NOT NULL,
  content   VARCHAR(65535) NOT NULL,
  ttl       INT            NOT NULL,
  CONSTRAINT c_lowercase_name CHECK (name :: TEXT = LOWER(name :: TEXT)),
  CONSTRAINT c_uppercase_type CHECK (type :: TEXT = UPPER(type :: TEXT)),
  CONSTRAINT c_domain_exists FOREIGN KEY (domain_id) REFERENCES domains (id) ON DELETE RESTRICT ON UPDATE RESTRICT
);

CREATE UNIQUE INDEX IF NOT EXISTS idx_uniq_record
  ON records
  USING btree (domain_id, name, type, content);

CREATE INDEX IF NOT EXISTS idx_record
  ON records
  USING gist (domain_id, name, type, content);


CREATE TABLE change_log (
  version   CHAR(32) PRIMARY KEY NOT NULL,
  origin    VARCHAR(255)         NOT NULL,
  serial    INT                  NOT NULL,
  operation VARCHAR(32)          NOT NULL,
  name      VARCHAR(255),
  type      VARCHAR(10),
  content   VARCHAR(65535),
  ttl       INT,
  CONSTRAINT c_lowercase_origin CHECK (origin :: TEXT = LOWER(origin :: TEXT)),
  CONSTRAINT c_operation_enum CHECK (
    operation :: TEXT
    IN ('domain-add', 'domain-delete', 'domain-clear',
        'record-add', 'record-delete', 'record-update-ttl')
  ),
  CONSTRAINT c_lowercase_name CHECK (name :: TEXT = LOWER(name :: TEXT)),
  CONSTRAINT c_uppercase_type CHECK (type :: TEXT = UPPER(type :: TEXT))
);

CREATE INDEX IF NOT EXISTS idx_change_log_origin
  ON change_log
  USING btree (name);