DO LANGUAGE plpgsql $E8C86824362F4A9E860A71D5B9DA19D7$
DECLARE found_domain_id INT;
DECLARE domain_serial INT;
DECLARE domain_exists BOOLEAN;
BEGIN
  -- Защитимся от Duplicate Error, потому что может статься что мы
  -- уже имеем запись, но у неё просто нет pdd_domain_id
  SELECT EXISTS (SELECT 1 FROM domains WHERE name = :origin) INTO domain_exists;

  IF NOT domain_exists
  THEN
    INSERT INTO domains (name, serial, is_technical, pdd_sync_enabled, pdd_domain_id)
    VALUES (:origin, 1, :technical, TRUE, :domain_id)
        RETURNING id, serial
          INTO found_domain_id, domain_serial;

    INSERT INTO change_log (version, origin, serial, operation)
    VALUES (:version, :origin, domain_serial, 'domain-add');

    {queries}
  END IF;
END$E8C86824362F4A9E860A71D5B9DA19D7$;
