SELECT
  r.id            AS id,
  d.pdd_domain_id AS domain_id,
  d.name          AS origin,
  d.pdd_sync_enabled AS sync_enabled,
  r.name          AS name,
  r.type          AS type,
  r.content       AS content,
  r.ttl           AS ttl
FROM domains AS d
  LEFT JOIN records AS r ON d.id = r.domain_id
WHERE d.pdd_domain_id IS NOT NULL
  AND d.pdd_domain_id > :starts_from
ORDER BY d.pdd_domain_id;
