SELECT r.id                                                                                               AS id,
       d.id                                                                                               AS domain_id,
       CONCAT(LOWER(d.name), '.')                                                                         AS origin,
       True                                                                                               AS sync_enabled,
       COALESCE(NULLIF(TRIM(TRAILING '.' FROM TRIM(TRAILING LOWER(d.name) FROM REPLACE(LOWER(r.name), '@', '\\@'))), ''), '@') AS name,
       r.type                                                                                             AS type,
       CASE r.type
         WHEN 'MX'
                 THEN CONCAT(r.prio, ' ', r.content)
         WHEN 'SRV'
                 THEN CONCAT(COALESCE(CONCAT(r.prio, ' '), ''), r.content)
         ELSE r.content
           END                                                                                            AS content,
       r.ttl                                                                                              AS ttl
FROM domains AS d
       LEFT JOIN records AS r ON d.id = r.domain_id
WHERE d.id != 1
  AND d.id > :starts_from
  AND LENGTH(d.name) <= 253
  AND (
          r.id IS NULL OR
          (
              r.id NOT IN (1482699, 15410071, 43512722) AND
              (
                (
                    COALESCE(NULLIF(TRIM(TRAILING '.' FROM TRIM(TRAILING LOWER(d.name) FROM REPLACE(LOWER(r.name), '@', '\\@'))), ''), '@') = '@' AND
                    r.type = 'SOA'
                  ) OR
                  COALESCE(NULLIF(TRIM(TRAILING '.' FROM TRIM(TRAILING LOWER(d.name) FROM REPLACE(LOWER(r.name), '@', '\\@'))), ''), '@') != '@' OR
                  r.type NOT IN ('SOA', 'NS', 'CNAME')
              )
          )
      )
ORDER BY d.id;