# encoding: UTF-8

import subprocess

import click
import psycopg2.extensions

from appcore.injection import inject


def extract_database_dsn(app):
    with app.app_context():
        engine = inject('master_engine')
        args, kwargs = engine.dialect.create_connect_args(engine.url)
        return psycopg2.extensions.make_dsn(*args, **kwargs)


@click.command(
    context_settings=dict(
        allow_extra_args=True,
        ignore_unknown_options=True,
    ),
    add_help_option=False,
)
@click.pass_context
def pgmigrate(ctx):
    dsn = extract_database_dsn(ctx.obj)
    environment = inject('environment', ctx.obj)

    args = [
        '/opt/dns-hosting/bin/pgmigrate',
        '-c', dsn,
        '-d', environment.get_property('assets_root'),
    ]
    args += list(ctx.args)

    exit(subprocess.call(args))
