# encoding: UTF-8

import click

from appcore.injection import Injected
from dns_hosting.services.dnsmaster.dnsserver import DNSMasterDNSServer
from dns_hosting.services.dnsmaster.httpserver import DNSMasterHttpServer
from dns_hosting.utils.cli import ApplicationCommand


class DNSMasterDNSCommand(ApplicationCommand):
    dnsmaster_server = Injected('dnsmaster_dns_server')  # type: DNSMasterDNSServer

    def callback(self):
        try:
            self.dnsmaster_server.serve_forever()
        except KeyboardInterrupt:
            pass


class DNSMasterHttpCommand(ApplicationCommand):
    dnsmaster_server = Injected('dnsmaster_http_server')  # type: DNSMasterHttpServer

    def callback(self):
        try:
            self.dnsmaster_server.serve_forever()
        except KeyboardInterrupt:
            pass


@click.group()
def dnsmaster():
    pass


dnsmaster.add_command(DNSMasterDNSCommand('dns'))
dnsmaster.add_command(DNSMasterHttpCommand('http'))
