# encoding: UTF-8

import click
from ws_properties.environ.environment import Environment

from appcore.injection import Injected
from dns_hosting.services.dnsserver.dnsserver import NsdDnsServer
from dns_hosting.services.dnsserver.properties import NsdServerProperties
from dns_hosting.services.dnsserver.statserver import NsdStatServer
from dns_hosting.utils.cli import ApplicationCommand


class NsdDnsServerCommand(ApplicationCommand):
    environment = Injected('environment')  # type: Environment

    def callback(self):
        nsd_server_props = NsdServerProperties(self.environment, 'nsd')
        nsd_dns_server = NsdDnsServer(nsd_server_props)
        try:
            nsd_dns_server.serve_forever()
        except KeyboardInterrupt:
            pass


class NsdStatServerCommand(ApplicationCommand):
    environment = Injected('environment')  # type: Environment

    def callback(self):
        nsd_server_props = NsdServerProperties(self.environment, 'nsd')
        nsd_stat_server = NsdStatServer(nsd_server_props)
        try:
            nsd_stat_server.serve_forever()
        except KeyboardInterrupt:
            pass


@click.group()
def nsd():
    pass


nsd.add_command(NsdDnsServerCommand('dns-server'))
nsd.add_command(NsdStatServerCommand('stat-server'))
