# encoding: UTF-8

import logging

import click

from appcore.injection import register_injection
from dns_hosting.cli.database import pgmigrate
from dns_hosting.cli.pdd import pdd
from dns_hosting.cli.server import run_server
from dns_hosting.cli.shell import py_shell
from dns_hosting.cli.dnsmaster import dnsmaster
from dns_hosting.cli.dnsserver import nsd
from dns_hosting.utils.logging_formatters import DeployFormatter, TskvFormatter

def lazy_setup_cli_logger(*args, **kwargs):

    config_custom_sidecar = False

    
    stdout_handler = logging.StreamHandler()
    stdout_handler.setLevel(logging.INFO)
    stdout_handler.setFormatter(TskvFormatter())

    if config_custom_sidecar:
        syslog_to_UA_handler = logging.handlers.SysLogHandler(address='/var/run/custom_unified_agent.sock')
        syslog_to_UA_handler.setLevel(logging.INFO)
        syslog_to_UA_handler.setFormatter(DeployFormatter())

    logger = logging.getLogger()
    logger.setLevel(logging.INFO)
    logger.addHandler(stdout_handler)
    if config_custom_sidecar:
        logger.addHandler(syslog_to_UA_handler)

def configure_cli(app, _):
    cli = click.Group(callback=lazy_setup_cli_logger)
    cli.context_settings['obj'] = app

    cli.add_command(pgmigrate)
    cli.add_command(py_shell)
    cli.add_command(run_server)
    cli.add_command(pdd)
    cli.add_command(dnsmaster)
    cli.add_command(nsd)

    register_injection(app, 'cli', cli)
