# encoding: UTF-8

import sqlalchemy.orm as orm
import zope.sqlalchemy.datamanager as dmanager

from appcore.data.session import SessionSelector
from appcore.injection import inject
from appcore.injection import register_injection
from appcore.tx.plugin import TxPlugin
from dns_hosting.dao.domains import DomainRepository, ChangeLogRepository
from dns_hosting.dao.domains import RecordRepository


def configure_dao(app, environment):
    tx_plugin = TxPlugin(app)

    master_session_factory = None
    if 'db-master' in environment.profiles:
        master_session_factory = orm.sessionmaker(
            inject('master_engine', app),
            # extension=dmanager.ZopeTransactionExtension(
            #     initial_state=dmanager.STATUS_CHANGED,
            #     transaction_manager=tx_plugin.tx_manager,
            # ),
        )
        master_session_factory = orm.scoped_session(master_session_factory)
        register_injection(
            app,
            'master_session_factory',
            master_session_factory,
        )

    slave_session_factory = None
    if 'db-slave' in environment.profiles:
        slave_session_factory = orm.sessionmaker(
            inject('slave_engine', app),
            # extension=dmanager.ZopeTransactionExtension(
            #     initial_state=dmanager.STATUS_READONLY,
            #     transaction_manager=tx_plugin.tx_manager,
            # ),
        )
        slave_session_factory = orm.scoped_session(slave_session_factory)
        register_injection(
            app,
            'slave_session_factory',
            slave_session_factory,
        )

    session_factory = None
    if master_session_factory is not None and slave_session_factory is not None:
        session_factory = SessionSelector(
            master_session_factory,
            slave_session_factory,
        )
    elif master_session_factory is not None:
        session_factory = master_session_factory
    elif slave_session_factory is not None:
        session_factory = slave_session_factory

    if session_factory is not None:
        register_injection(app, 'session_factory', session_factory)

        domain_repository = DomainRepository(session_factory)
        register_injection(app, 'domain_repository', domain_repository)

        record_repository = RecordRepository(session_factory)
        register_injection(app, 'record_repository', record_repository)

        changelog_repository = ChangeLogRepository(session_factory)
        register_injection(app, 'changelog_repository', changelog_repository)
